
***********************************
***								***
***	Tips for Optimizing Stata	***
***			Asjad Naqvi			***
***								***
*** 	Stata DPC Webinar 		***
***   	  14th Nov 2025   		***
***								***
***********************************

// prep file



clear 


cap cd "D:\Dropbox\STATA - MEDIUM\Webinar - StataTips Nov 2025"




*********************
*** data handling ***
*********************

use testdata, clear


*** splitting id

ren v1 id


split id, parse("_")  destring 

tab id1 id2


fillin id1 id2
tab _fillin

drop _fillin

ren id1 country
ren id2 sector

drop id

order country sector


************************************
*** fixing variables, precision  ***
************************************

recode direct indirect (.=0)



gen 		total1 = direct + indirect
gen double  total2 = direct + indirect

gen diff = total2 - total1

summ diff, d

gen 	   direct_share1  = direct / total1
gen double direct_share2  = direct / total2



gen 	   indirect_share1  = indirect / total1
gen double indirect_share2  = indirect / total2


gen check1 = direct_share1 + indirect_share1
gen check2 = direct_share2 + indirect_share2


tab check1
tab check2

count if check1==1
count if check2==1


**********************
*** concatenation ****
**********************


gen id = country + "_" + string(sector)

sort id
sort country sector


format sector %02.0f

cap drop id
gen id = country + "_" + string(sector, "%02.0f")


**********************
*** batch renaming ***
**********************

keep country sector direct indirect direct_share2 indirect_share2
ren *2 *


**** reshape option 1

/*
reshape wide direct indirect direct_share indirect_share, i(country) j(sector)
reshape long
reshape wide direct@ indirect@ direct@_share indirect@_share, i(country) j(sector)
recode direct* indirect* (.=0)
*/


**** reshape option 2

/*

keep country sector direct_share indirect_share

*ren *share share_*
*ren *_ *

reshape long @_share , i(country sector) j(type) string
ren share_ share
reshape wide share, i(country type) j(sector)
*/


tab sector

levelsof sector
return list

lab var direct_share 	"Direct (%)"
lab var indirect_share 	"Indirect (%)"

replace direct_share 	= . if !inrange(direct_share, -100, 100)
replace indirect_share 	= . if !inrange(indirect_share, -100, 100)

tabstat direct_share indirect_share, c(stat) stat(mean sd min max n) by(sector)

/*
graph bar (mean) direct_share indirect_share, stack ///
	over(sector) nooutsides ///
		yline(0)	///
		legend(pos(6) row(1))	///
		xsize(3) ysize(1)


		
		
graph bar (mean) direct_share indirect_share if country=="FRA", stack ///
	over(sector) nooutsides ///
		yline(0)	///
		legend(order(1 "Direct" 2 "Indirect") pos(6) row(1))	///
		xsize(3) ysize(1)
*/		
		
		
levelsof country, local(lvls)

foreach x of local lvls {
	
	display in yellow "Country = `x'"
	
	/*
	graph bar (mean) direct_share indirect_share if country=="`x'", stack ///
		over(sector) nooutsides ///
			yline(0)	///
			legend(order(1 "Direct" 2 "Indirect") pos(6) row(1))	///
			xsize(3) ysize(1)
		
	graph export "./figures/impacts_`x'.png", replace wid(2000)
	*/
}
		
		
		
		
**************************
***   reshape test    ****
**************************

use reshape_test, clear

ren epsilon* eps*

reshape long eps_@_1 eps_@_2 eps_@_3 eps_@_4 , i(iso3) j(from)

reshape long eps__ , i(iso3 from) j(to)

ren eps__ eps


***********************************
**** describe without loading ****
**********************************

use wbindicators, clear

describe using wbindicators
describe using wbindicators, simple
return list


use country* region* ny_gdp_pcap_pp_kd ne_trd_gnfs_zs ne_exp_gnfs_zs ne_imp_gnfs_zs using wbindicators, clear

tab  regionname region



use if region!="NA" using wbindicators, clear

*use iso3 countryname region year ne* if region!="NA" using wbindicators, clear



*********************************
**** searching for variables ****
*********************************

import delim using "dataset_2025-08-31T21_57_24.168923664Z_DEFAULT_INTEGRATION_IMF.STA_IIP_13.0.0.csv", ///
	clear bindquote(strict) encoding(utf8)


ds, has(type string)
ds, has(type numeric)	
	
ds, has(varlabel *-Q*)
return list

drop `r(varlist)'

foreach x of varlist v* {
	local t : var label `x'
	ren `x' y`t'
}







