{smcl}
{*:author: C. Brzinsky-Fay, started: 07/2025, datasets: data1.dta, citytemp.dta}
{*:version 1.0}

{center:{ul on}{yellow:Interactive Help Files: Histogramme}{ul off}}

{center:{hi:Christian Brzinsky-Fay, Universität Hamburg}}
{center:{it:Kontakt: christian.brzinsky-fay@uni-hamburg.de}}



{hline}

{pstd}
Histogramme dienen der univariaten Analyse von metrisch-skalierten Variablen. 
Der Stata-Befehl {cmd:histogram} bietet hier die wichtigsten Funktionen an.
Für speziellere Anwendungen kann man auch auf weitere Befehle aus dem SSC-Archiv zurückgreifen.
Hier demonstriere ich Ihnen die Hauptanwendungen dieser Befehle.

{hline}

{marker inhalt}
{center:{ul on}{yellow:Übersicht}{ul off}}

{p 6 6 2}
{yellow:Grundlagen}

{phang2} {help iahf_de_hist##introhist:1) Die erste Anwendung}{break} {p_end}
{phang2} {help iahf_de_hist##diskret:2) Wenn die Variable diskret ist}{break} {p_end}
{phang2} {help iahf_de_hist##yachse:3) Die y-Achse}{break} {p_end}
{phang2} {help iahf_de_hist##titeletc:4) Titel, Untertitel, Hinweise}{break} {p_end}
{phang2} {help iahf_de_hist##balkenlabs:5) Balkenbeschriftungen}{break} {p_end}
{phang2} {help iahf_de_hist##zuskurven:6) Zusätzliche Verteilungskurven}{break} {p_end}

{p 6 6 2}
{yellow:Weiterführendes}

{phang2} {help iahf_de_hist##byoption:7) by-Option}{break} {p_end}
{phang2} {help iahf_de_hist##balkeninter:8) Balken und Intervalle}{break} {p_end}
{phang2} {help iahf_de_hist##farben:9) Das Auge isst mit}{break} {p_end}
{phang2} {help iahf_de_hist##addedplots:10) Zusätzliche Plots}{break} {p_end}

{p 6 6 2}
{yellow:Professionelles}

{phang2} {help iahf_de_hist##addedlines:11) Zusätzliche Linien}{break} {p_end}
{phang2} {help iahf_de_hist##classdata:12) Balkenbreiten in Datensatz}{break} {p_end}
{phang2} {help iahf_de_hist##flexwidth:13) Histogramme mit variierenden Balkenbreiten}{break} {p_end}
{phang2} {help iahf_de_hist##mirrored:14) Gespiegelte Histogramme}{break} {p_end}

{hline}

{marker introhist}
{title:1) Die erste Anwendung}

{pstd}
Wir laden zunächst den Beispieldatensatz {cmd:data1.dta}, der eine Reihe von Variablen aus dem Sozio-ökonomischen Panel (SOEP) enthält. 

{phang2} {stata use "data1.dta", clear} {p_end}

{phang2} {stata describe} {p_end}

{pstd}
In der Variablenliste, die wir mit {cmd:describe} erzeugt haben, finden wir die Variable {cmd:rent}, die die monatlich gezahlte Miete der Befragungspersonen enthält.
Diese Variable ist metrisch-skaliert und kontinuierlich, d.h. sie hat sehr viele Werte (Ausprägungen) und die Abstände zwischen den Zahlenwerten sind vergleichbar.
Die univariate Inspektion einer kontinuierlichen Variable kann immer grafisch und statistisch durchgeführt werden.
Mit einem Histogram können wir die Verteilung von {cmd:rent} grafisch darstellen.

{phang2} {stata histogram rent} {p_end}

{pstd}
Die erzeugte Grafik zeigt auf der horizontalen x-Achse den Wertebereich der Variablen und auf der vertikalen y-Achse die Häufigkeitsdichte (density).
Dieses Maß ist in der Statistik üblich, aber für statistisch unerfahrene Personen nicht unbedingt unmittelbar verständlich.
Aus diesem Grund fügen wir die Option {cmd:frequency} zum {cmd:histogram}-Befehl hinzu, die in physischer Hinsicht das gleiche Diagramm darstellt, mit der Ausnahme einer verständlicheren y-Achsenbeschriftung.
 
{phang2} {stata histogram rent, frequency}

{pstd}
Nun haben wir die absolute Häufigkeit auf der vertikalen y-Achse abgetragen und können diese für jeden Balken ablesen.
Der höchste Balken bei ca. 500$ zeigt die höchste Häufigkeit mit 600 Beobachtungen.
Dieser Balken hat allerdings eine bestimmte Breite (wie die anderen Balken auch) und umfasst nicht nur einen einzelnen Wert der Variablen {cmd:rent} sondern einen Bereich bzw. ein Intervall.
Die Breite der Balken-Intervalle wird automatisch nach einer standardisierten Formel berechnet und ist in den meisten Fällen hilfreich.
Beachten Sie, dass bei der Ausgabe im Ergebnisfenster die Breite der berechneten Intervalle (hier: {cmd:width=128.84848}) sowie die Zahl der sich daraus ergebenen Balken (hier: {cmd:bin=33}) angezeigt wird.
Um die Grafik für unsere Zwecke anzupassen, können entweder die Breite der Intervalle oder die Anzahl der Balken mit Hilfe von Optionen verändert werden.

{phang2} {stata histogram rent, frequency width(200)}

{phang2} {stata histogram rent, frequency bins(100)}

{pstd}
Im ersten Beispiel wollen wir das Histogramm mit einer einheitlichen Intervallbreite von 200 Einheiten von {cmd:rent}, also US-Dollar, darstellen.
Im zweiten Beispiel wollen wir über die gesamte Breite 100 Balken im Histogramm angezeigt bekommen.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker diskret}
{title:2) Wenn die Variable diskret ist}

{pstd}
Metrisch-skalierte Variablen, die nur wenige Ausprägungen haben, sind diskret. 
In der Regel sind diese wenigen Ausprägungen natürliche Zahlen, d.h. sie haben keine Dezimalstellen. 
Beispielsweise wird die Lebenszufriedenheit einer Person auf einer Skala von 0-10 abgefragt.
Das heißt, dass diese Variable nur 11 ganzzahlige Ausprägungen hat, da Werte dazwischen, wie z.B. 3.4 oder 5.1, nicht vorkommen.
Auch für diese Variablen kann man ein Histogram erstellen.

{phang2} {stata use "data1.dta", clear} {p_end}

{phang2} {stata histogram lsat, frequency} {p_end}

{pstd}
Die erste Auffälligkeit ist ein großer Abstand zwischen den Balken.
Außerdem sind die Abstände zwischen den Balken ungleich groß und die Balken sind nicht über die ganzzahligen Werte der x-Achse zentriert.
Das liegt daran, dass die Balkenbreite und -anzahl - also die Intervallbreite für jeden Balken - anhand einer standardisierten Formel berechnet werden, die nicht zwingend ganzzahlige Werte liefert.
Für eine Darstellung der Verteilung von diskreten metrisch-skalierten Variablen ist diese Berechnung von Intervallen nicht hilfreich.

{phang2} {stata histogram lsat, frequency discrete} {p_end}

{pstd}
Mit Hilfe der Option {cmd:discrete} erreichen wir eine angemessene Darstellung von diskreten Variablen.
Es gibt nun so viele Balken wie diskrete Werte, die Lücken sind geschlossen und die Balken sind über den Werten der x-Achse zentriert.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker yachse}
{title:3) Die y-Achse}

{pstd}
Die y-Achsenbeschriftung im Histogramm ist standardmäßig die Häufigkeitsdichte (density), die allerdings für Nicht-Statistiker:innen nicht unmittelbar verständlich ist.

{phang2} {stata use "data1.dta", clear} {p_end}

{phang2} {stata histogram rent} {p_end}

{pstd}
Wir haben im ersten Abschnitt bereits die Option {cmd:frequency} kennengelernt, die statt dessen auf der y-Achse die absoluten Häufigkeiten abträgt. 
Die physische Form des Histogramms verändert sich durch die unterschiedliche y-Achsenskalierung nicht.

{phang2} {stata histogram rent, frequency} {p_end}

{pstd}
Mit der Option {cmd:percent} können wir auch die relativen Häufigkeiten auf der y-Achse darstellen.

{phang2} {stata histogram rent, percent} {p_end}

{pstd}
Der höchste Balken ist nach wie vor das Intervall um 500$. 
Sein Wert ist jetzt allerdings nicht die absolute, sondern die relative Häufigkeit mit ein wenig mehr als 25%.
Wieder ist die Form der Grafik nicht verändert.

{pstd}
Eine vierte Möglichkeit der y-Achsenbeschriftung ist mit der Option {cmd:fraction} gegeben. Hier wird ebenfalls die relative Häufigkeit dargestellt, allerdings nicht als Prozentzahl (25%), sondern als entsprechende Bruchzahl (0.25).

{pmore3}
{ul:Anmerkung:} Wie viele andere Statistikprogramme auch, stellt Stata Dezimalbrüche, die kleiner sind als 1, ohne die vorangestellte 0 dar.
Die Zahl {cmd:0.25} wird in Diagrammen und Tabellen von Stata als {cmd:.25} dargestellt.
Innerhalb von Statas Befehlssyntax können beide Schreibweisen verwendet werden.

{phang2} {stata histogram rent, fraction} {p_end}

{pstd}
Welche Beschriftung Nutzer:innen verwenden wollen, hängt von persönlichen Vorlieben oder von Vorgaben bei der Publikation seitens der Herausgeber:innen ab.
Die Optionen {cmd:frequency}, {cmd:percent} und {cmd:fraction} (genauso die Standardeinstellung {cmd:density}) können nicht in Kombination verwendet werden.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker titeletc}
{title:4) Titel, Untertitel, Hinweise}

{pstd}
Selbstverständlich benötigen Diagramme Titel und weitere Erläuterungen, um sicherzustellen, das ein Ergebnis von Leser:innen korrekt dekodiert bzw. verstanden wird.
Für alle Grafiken in Stata stehen hierfür die Optionen {cmd:title()}, {cmd:subtitle()} und {cmd:note()} zur Verfügung.
In die Klammern wird der Text des Titels, Untertitels oder des Hinweises in Anführungszeichen geschrieben.

{phang2} {stata use "data1.dta", clear} {p_end}

{phang2} {stata histogram lsat, frequency discrete title("Lebenszufriedenheit")} {p_end}

{pmore3}
{ul:Anmerkung:} Da es viele veränderbare Eigenschaften bei Grafik-Befehlen gibt, haben sie i.d.R. sehr viele Optionen.
Mit zunehmender Zahl von Optionen werden die Stata-Befehle immer länger und zugleich unlesbarer.
Um in Do-Files eine größere Übersichtlichkeit zu erreichen, empfiehlt sich der Einsatz von Zeilenumbrüchen mit "{cmd:///}".
Hiermit lassen sich auch Sub-Optionen schnell erkennen, und die Befehlsstruktur ist besser verständlich. {p_end}
{cmd}
        histogram lsat,	///
		frequency ///
		discrete ///
		title("Lebenszufriedenheit") ///
		subtitle("0 = gar nicht zufrieden, 10 = sehr zufrieden") {txt}
        {it:({stata iahf_hist_ex hist1de:Zum Starten hier klicken})}

{pstd}
Zusätzlich zu Titel und Untertitel, die über den Diagrammen angezeigt werden, gibt es auch die Möglichkeit, unter dem Diagramm eine Notiz oder einen Hinweis einzufügen.
Hierfür wird die Option {cmd:note()} verwendet, bei der in Klammern genauso der entsprechende Text angegeben wird wie bei den Titel-Optionen. {p_end}
{cmd}
        histogram lsat,	///
		frequency ///
		discrete ///
		title("Lebenszufriedenheit") ///
		subtitle("0 = gar nicht zufrieden, 10 = sehr zufrieden") ///
		note("Quelle: Sozioökonomisches Panel (2009)") {txt}
        {it:({stata iahf_hist_ex hist2de:Zum Starten hier klicken})}

{pmore3}
{ul:Anmerkung:} Die Texte des Titels etc. müssen nicht unbedingt in Anführungszeichen geschrieben werden.
Allerdings werden Ausdrücke in Anführungszeichen im Do-File-Editor farblich hervorgehoben.
Dies erleichtert bedeutend das Durchsuchen von längeren Do-Files im späteren Gebrauch.

{pstd}
Untertitel haben eine kleinere Schriftgröße als Titel, und Notizen werden standardmäßig in deutlich kleinerer Schrift ausgegeben.
Über entsprechende Sub-Optionen können hier aber auch Anpassungen vorgenommen werden.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker balkenlabs}
{title:5) Balkenbeschriftungen}

{pstd}
Zur schnelleren Lesbarkeit von Graphen trägt u.U. die Beschriftung der Datenpunkte bei.
Bei Histogrammen wäre dies die Beschriftung der Balkenhöhen, durch die sich Leser:innen das mühsame und ungenaue Ablesen der Balkenhöhe an der y-Achse ersparen können.
Hierfür fügen wir dem {cmd:histogram}-Befehl die Option {cmd:addlabels} hinzu.

{phang2} {stata use "data1.dta", clear} {p_end}

{phang2} {stata histogram lsat, frequency discrete addlabels} {p_end}

{pstd}
Die Variable {cmd:lsat} ist diskret metrisch-skaliert, weshalb wir die Option {cmd:discrete} benötigen. 
Die Option {cmd:frequency} beschriftet die y-Achse mit der absoluten Häufigkeit.
Mit Hilfe der {cmd:addlabels}-Option können wir jetzt direkt die Balkenhöhe - also die absoluten Häufigkeiten - durch die Datenbeschriftung ablesen.
So haben 1533 Personen ihre Lebenszufriedenheit auf einer Skala von 0-10 mit dem Wert 8 angegeben.
Lediglich 68 Personen haben sich hier für den Wert 2 entschieden.

{pstd}
Analog funktionert das auch für relative Häufigkeiten. Allerdings erfordert hier die Tatsache, dass Dezimalzahlen dargestellt werden, eine zusätzliche Modifikation.

{phang2} {stata histogram lsat, percent discrete addlabels} {p_end}

{pstd}
Die Dezimalzahlen werden in der Grafik mit einer unterschiedlichen Zahl von Nachkommastellen angezeigt, was die Lesbarkeit einschränkt
Beim Wert 0 für die Lebenszufriedenheit auf der x-Achse wird die relative Häufigkeit bespielsweise mit 4 Dezimalstellen angezeigt (0.2442), während der Balken beim Wert von 8 lediglich mit einer Nachkommastelle (28.8) beschriftet ist.

{pstd}
Um diese unterschiedliche Darstellung zu verhindern, brauchen wir eine zusätzliche Option, die die Eigenschaften der Datenbeschriftungen (marker labels) modifiziert.
Diese Option heißt {cmd:mlabopts()} und hat wiederum eine Reihe von Sub-Optionen, mit denen die Eigenschaften der Datenbeschriftungen geändert werden können.
Für das Zahlenformat benötigen wir hier die Sub-Option {cmd:mlabformat()} mit einer auf den ersten Blick ein wenig kryptisch anmutenden Spezifikation.

{phang2} {stata histogram lsat, percent discrete addlabels addlabopts(mlabformat(%5.1f))} {p_end}

{pstd}
Die Spezifikation {cmd:%5.1f} bedeutet, dass die Datenbeschriftungen mit maximal {cmd:5} Ziffern angezeigt werden sollen, von denen nur {cmd:1} nach dem Dezimalpunkt gerundet werden soll.
Eine genaue und ausführliche Beschreibung aller Anzeigeformate finden Sie mit {cmd:help format}.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker zuskurven}
{title:6) Zusätzliche Verteilungskurven}

{pstd}
Eine wichtige Eigenschaft von Verteilungen, die mit Hilfe von Histogrammen untersucht werden kann, ist die Verteilungsform.
Hierbei interessiert in erster Linie, ob eine Verteilung links- bzw. rechtsschief ist oder ob sie normalverteilt ist.
Bestimmte statistischen Anwendungen erfordern eine Normalverteilung der beteiligten Variablen.

{pstd}
Mit dem {cmd:histogram}-Befehl können wir die grafische Überprüfung der Normalverteilung einer Variablen vornehmen, indem wir die Option {cmd:normal} hinzufügen.

{phang2} {stata use "data1.dta", clear} {p_end}

{phang2} {stata histogram lsat, frequency discrete normal} {p_end}

{pstd}
Die nun in das Diagramm eingezeichnete Normalverteilungskurve wird auf der Basis des arithmetischen Mittels und der Standardabweichung der Variable {cmd:lsat} berechnet.
Sie sollte durch die Gipfel der Histogrammbalken verlaufen, wenn die Variable normalverteilt ist.

{pstd}
In unserem Beispiel gibt es jedoch deutliche Abweichungen von der Normalverteilungskurve, und zwar v.a. bei den Werten 6 und 8.
Wir sehen hier, dass die Variable {cmd:lsat} nicht normalverteilt ist, sondern linksschief bzw. rechtssteil.

{pstd}
Wenn wir eine kontinuierliche metrisch-skalierte Variable darstellen wollen, z.B. die monatliche Miete, können wir auf die {cmd:discrete}-Option verzichten.

{phang2} {stata histogram rent, frequency normal} {p_end}

{pstd}
Auch hier gibt es deutliche Abweichungen von der theoretischen Normalverteilung.
Die Verteilung der Variablen {cmd:rent} ist rechtsschief bzw. linkssteil.

{pstd}
Wir können zur genaueren visuellen Inspektion eine sogenannte Kernel-Dichte-Funktion in das Histogramm einfügen.
Diese Funktion schätzt den Verlauf der Verteilung lokal, d.h. eventuell bestehende lokale Abweichungen von der Normalverteilung werden in der Kurve wiedergegeben.
Durch einen Vergleich der durch die {cmd:normal}-Option erzeugten Normalverteilungskurve mit der durch die Option {cmd:kdensity} erzeugten Dichtefunktion lassen sich Rückschlüsse ziehen, ob die untersuchte Variable normalverteilt ist.

{phang2} {stata histogram rent, frequency normal kdensity} {p_end}

{pstd}
In unserem Beispiel verlaufen die beiden Kurven recht unterschiedlich, sind also kaum deckungsgleich.
Demzufolge ist die untersuchte Variable {cmd:rent} nicht normalverteilt.

{pstd}
Bei diskreten metrisch-skalierten Variablen kann die durch die Option {cmd:kdensity} erzeugte Kurve seltsame Fromen annehmen.

{phang2} {stata histogram lsat, frequency discrete normal kdensity} {p_end}

{pstd}
Der Grund ist wiederum in den ganzzahligen Abständen zwischen den Werten von {cmd:lsat} zu finden.
Da zwischen den Werten 3 und 4 beispielsweise keine Werte vorkommen können, senkt sich die lokale Dichte hier immer auf nahezu 0 ab.
Eine solche Kurve ist nicht hilfreich hinsichtlich eines Vergleichs mit der durch die Option {cmd:normal} erzeugten theoretischen Normalverteilungskurve.

{pstd}
Dieses Problem kann man damit umgehen, dass neben der {cmd:kdensity}-Option zusätzlich eine {cmd:kdenopts()}-Option mit einer entsprechenden Sub-Option genutzt wird.
Die hilfreiche Sub-Option ist hier {cmd:bwidth(1)}, die die Berechnung der Dichte auf die ganzzahligen Werte von {cmd:lsat} beschränkt und damit eine annähernd stetige Kurve liefert.

{phang2} {stata histogram lsat, frequency discrete normal kdensity kdenopts(bwidth(1))} {p_end}

{pstd}
Auch bei dieser Variable sind beide Kurven nicht deckungsgleich, d.h. die Variable {cmd:lsat} ist nicht normalverteilt.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker byoption}
{title:7) by-Option}

{pstd}
Oft ist die Verteilung einer metrisch-skalierten Variable interessant für einen Vergleich über die Kategorien einer anderen Variable.
Beispielsweise könnte man sich die Lebenszufriedenheit für Männer und Frauen getrennt anschauen, um Geschlechterunterschiede aufzuspüren und zu erklären.

{phang2} {stata use "data1.dta", clear} {p_end}

{phang2} {stata histogram lsat, frequency discrete by(sex)} {p_end}

{pstd}
Es werden jetzt zwei Diagramme für Männer und Frauen erzeugt, die nebeneinander stehen.
Die y-Achse stellt die absoluten Häufigkeiten der Skalenpunkte dar und ist für beide Teilgrafiken dieselbe, um einen Vergleich zu ermöglichen.

{pstd}
Der direkte Vergleich der Antwortkategorien 0-10 ist durch die Darstellung nebeneinander ein wenig erschwert.
Die {cmd:by}-Option erlaubt zur Anpassung der Darstellung eine Reihe von Sub-Optionen.
Die {cmd:cols()}-Suboption bestimmt besipielsweise, in wie vielen Spalten die durch {cmd:by} erzeugten Unterdiagramme angezeigt werden sollen.

{phang2} {stata histogram lsat, frequency discrete by(sex, cols(1))} {p_end}

{pstd}
Der Parameter {cmd:1} legt demnach fest, dass die Unterdiagramme in einer Spalte, also übereinander dargestellt werden.
So wird der direkte Vergleich der Kategorien erleichtert.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker balkeninter}
{title:8) Balken und Intervalle}

{pstd}
Wir haben im ersten Abschnitt bereits die Möglichkeiten kennengelernt, die Anzahl der Balken bzw. deren Breite mit den Optionen {cmd:bins()} bzw. {cmd:width()} zu modifizieren.
Beide Optionen können nur alternativ verwendet werden, da sich aus der Zahl der Balken die Intervallbreite und umgekehrt ergibt.

{pstd}
Es ist bei unbekannten Verteilungen einer Variablen grundsätzlich empfehlenswert, mehrere Histogramme mit verschiedenen Intervallen bzw. Balkenanzahlen zu erstellen, um evtl. bi- oder multimodale Verteilungen zu identifizieren.

{pstd}
Zur Demonstration laden wir einen von Statas mitgelieferten Beispieldatensätzen. 
Für diese Datensätze kann der Befehl {cmd:sysuse} verwendet werden.
Die Option {cmd:clear} brauchen wir hier, weil wir vorher einen anderen Datensatz geladen hatten.

{phang2} {stata sysuse "citytemp.dta", clear} {p_end}

{phang2} {stata describe} {p_end}

{pstd}
Der Datensatz {cmd:citytemp} enthält u.a. Januar- und Juli-Temperaturen (in Fahrenheit) in den Regionen der Vereinigten Staaten.
Zunächst schauen wir uns die Verteilung der Januar-Temperaturen mit den Standard-Einstellungen an.

{phang2} {stata histogram tempjan} {p_end}

{pstd}
Stata gibt bei der Ausführung des Befehls im Ergebnisfenster die automatische Berechnung der Intervalle und Balken an ({cmd:bin=29} bzw. {cmd:width=2.4275862}).
Wenn wir nun die Balkenanzahl verringern, bekommen wir ein gröberes Bild der Verteilung. Vergrößern wir dagegen die Zahl der Balken, bekommen wir eine detailliertere Darstellung.
Mit der {cmd:name()}-Option geben wir beiden Graphen jeweils einen Namen und mit dem {cmd:graph combine}-Befehl werden beide Graphen in einer gemeinsamen Darstellung zusammengefasst.

{phang2} {stata histogram tempjan, bins(10) frequency name(grob, replace)} {p_end}

{phang2} {stata histogram tempjan, bins(100) frequency name(fein, replace)} {p_end}

{phang2} {stata graph combine grob fein, cols(1)} {p_end}

{pstd}
Innerhalb der {cmd:name()}-Optionen befindet sich die Sub-Option {cmd:replace}.
Diese sorgt dafür, dass bei mehrmaligem Ausführen des Befehls die Graphen ohne Fehlermeldung erneut gespeichert werden. 
Ohne {cmd:replace} würde bei der zweiten Ausführung des Befehls der Graph mit dem entsprechenden Namen bereits existieren und könnte nicht überschrieben werden.

{pstd}
Die Option {cmd:cols()} des {cmd:graph combine}-Befehls legt fest, dass die beiden Graphen in einer Spalte, also untereinander kombiniert werden sollen.

{pstd}
Analog zur {cmd:bin()}-Option könnte man auch die {cmd:width()}-Option verwenden.

{phang2} {stata histogram tempjan, width(0.5) frequency name(grob, replace)} {p_end}

{phang2} {stata histogram tempjan, width(10) frequency name(fein, replace)} {p_end}

{phang2} {stata graph combine grob fein, cols(1)} {p_end}

{pstd}
Bei der Darstellung von diskreten Variablen unter Verwendung der Option {cmd:discrete} machen die Optionen {cmd:bins} und {cmd:width} keinen Sinn, da die Breite der Balken durch die diskreten Werte (Ausprägungen) der Variablen vorgegeben ist.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker farben}
{title:9) Das Auge isst mit}

{pstd}
Bisher haben wir alle Histogramme mit Statas 'kosmetischen' Grundeinstellungen erzeugt. 
Die erste Standardfarbe für Grafiken ist immer ein kräftiges Blau. 
Die Rahmenlinien der einzelnen Balken haben die gleiche Farbe, aber in einer helleren Variante, und sind immer sehr dünn gezeichnet, so dass man sie nur marginal wahrnimmt.

{pstd}
In einer Präsentation oder Publikation ist es durchaus angebracht, Farben und Linien zu variieren, um bespielsweise verschiedene Variablen unterschiedlich darzustellen, die Leser:innen eine schnelle Unterscheidung ermöglicht.

{phang2} {stata use "data1.dta", clear} {p_end}

{phang2} {stata histogram lsat, frequency discrete color(red)} {p_end}

{pstd}
Die Option {cmd:color()} färbt die Balken und Ihre Rahmenlinien in der angegebenen Farbe ein (hier: rot).
Darüber hinaus gibt es für die Bestimmung der Füllfarbe der Balken die Option {cmd:fcolor()} und für die Bestimmung der Linienfarbe die Option {cmd:lcolor()}.

{phang2} {stata histogram lsat, frequency discrete fcolor(gold) lcolor(black)} {p_end}

{pmore3}
{ul:Anmerkung:} Ein Übersicht über die verfügbaren Farben und deren Anwendung in Befehle bekommt man unter {stata help colorstyle}.
Im Wesentlichen ist die Auswahl von Farben eine Geschmackssache; allerdings müssen Autor:innen gelegentlich Vorgaben von Verlagen oder Journals erfüllen.

{pstd}
Wenn man die Linien in der Farbe weiß zeichnet, bekommen die Balken einen kleinen, scheinbaren Abstand, was in optischer Hinsicht vorteilhaft ist (aber natürlich wiederum Geschmackssache ist).
Mit der Option {cmd:lwidth()} kann die Rahmenlinie verändert werden. Hier ist die Linienbreite {cmd:thick} gewählt.

{phang2} {stata histogram lsat, frequency discrete fcolor(emerald) lcolor(white) lwidth(thick)} {p_end}

{pmore3}
{ul:Anmerkung:} Ein Übersicht über die verfügbaren Linienstärken erhält man mit {stata help linewidthstyle}.

{pstd}
Histogramme sind prinzipiell dafür konzipiert, die Verteilung von metrisch-skalierten Variablen darzustellen.
Um die Stetigkeit von metrisch-skalierten Variablen grafisch zu verdeutlichen, sind die Abstände zwischen den Balken sehr klein bis nicht existent.
Wenn man die Linien der Histogramm-Balken zu breit gestaltet, wird aus dem Histogramm ein Säulendiagramm, das i.d.R. zur Darstellung von kategorialen Variablen verwendet wird.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker addedplots}
{title:10) Zusätzliche Plots}

{pstd}
In Abschnitt 7 habe ich beschrieben, wie man sich die Verteilung einer metrisch-skalierten Vaiable getrennt für zwei Kategorien einer anderen Variable (hier: {cmd:sex}) erzeugen lassen kann.
Prinzipiell ist das auch für Variablen mit mehreren Kategorien möglich.
Für die Darstellung von Histogrammen über eine Variable mit nur zwei Kategorien gibt es noch eine weitere Möglichkeit der Darstellung in einem Diagramm, und zwar mit der Option {cmd:addplot()}.

{phang2} {stata use "data1.dta", clear} {p_end}

{pstd}
Wir haben die Variable {cmd:income} für das individuelle Erwerbseinkommen in unserem Datensatz.
Diese Variable müssen wir vorab bearbeiten, da 1369 Personen die Angabe {cmd:0} (kein Einkommen) gemacht haben.
Zum Vergleich der erzielten Einkommen müssen wir diese Personen ausschließen, indem wir den Wert {cmd:0} als fehlenden Wert (missing value) deklarieren.

{phang2} {stata summarize income} {p_end}

{phang2} {stata count if income==0} {p_end}

{phang2} {stata mvdecode income, mv(0=.)} {p_end}

{pstd}
Gleichzeitig gibt es einige wenige Personen, die sehr viel Geld verdienen und als Ausreißer einen verzerrenden Einfluss auf die Interpretation von Verteilungsparametern haben könnten.
Aus diesem Grund schließen wir ebenfalls Einkommen aus, die größer als 100000$ sind.

{phang2} {stata replace income=. if income>100000} {p_end}

{pstd}
Wenn wir nun die Verteilung des Erwerbseinkommens für Männer und Frauen vergleichen wollen, können wir zunächst mit der {cmd:by}-Option zwei Histogramm übereinander anzeigen lassen.

{phang2} {stata histogram income, frequency by(sex, cols(1))} {p_end}

{pstd}
Wir sehen in dieser Gegenüberstellung bereits, dass es hinsichtlich der Einkommensverteilung Geschlechterunterschiede gibt.
Sowohl die x-Achse als auch die y-Achse sind für beide Teilgrafiken gleich skaliert, so dass ein direkter Vergleich der Balkenhöhen ermöglicht wird.

{pstd}
Eine elegantere Möglichkeit ergibt sich durch die Verwendung der {cmd:addplot()}-Option, mit der wir beide Grafiken übereinander legen können.
Diese Option funktioniert so, dass die Syntax für das zweite Histogramm inklusive ihrer Optionen als Argument in die Klammern der {cmd:addplot()}-Option geschrieben wird.

{pstd}
Um die beiden Plots nach Geschlecht zu unterscheiden, verwenden wir einerseits die {cmd:if}-Bedingung und verschiedene Farben.
Zunächst erzeugen wir beide Histogramme separat.
Die Variable {cmd:sex} hat den Wert {cmd:1} für Männer und {cmd:2} für Frauen.

{phang2} {stata histogram income if sex==1, frequency color(emerald)} {p_end}

{phang2} {stata histogram income if sex==2, frequency color(gold)} {p_end}

{pstd}
Beide Histogramme kann man nun überlagern, indem eine zweite {cmd:histogram}-Syntax in eine {cmd:addplot()}-Option einbaut. {p_end}
{cmd}
        histogram income if sex==1, ///
		frequency ///
		color(emerald) ///
		xtitle("Individuelles Erwerbseinkommen") ///
		title("Einkommensverteilung nach Geschlecht") ///
		addplot(histogram income if sex==2, frequency color(gold)) {txt}
        {it:({stata iahf_hist_ex hist3de:Zum Starten hier klicken})}

{pstd}
Hier treten nun zwei Probleme auf: erstens verdeckt ein Diagramm das andere und zweitens ist die Legende nicht informativ.
Das erste Problem können wir mit dem Hinzufügen einer Transparenz (d.h. einer Deckkraft von z.B. 30%) zu den Farben lösen.
Das zweite Problem würde die Modifikation der Legende mit der {cmd:legend}-Option erfordern.
Der Einfachheit halber lösen wir das zweite Problem an dieser Stelle, indem wir lediglich die Legende ausblenden. {p_end}
{cmd}
        histogram income if sex==1, ///
		frequency ///
		color(emerald%30) ///
		xtitle("Individuelles Erwerbseinkommen") ///
		title("Einkommensverteilung nach Geschlecht") ///
		addplot(histogram income if sex==2, frequency color(gold%30)) ///
		legend(off) {txt}
        {it:({stata iahf_hist_ex hist4de:Zum Starten hier klicken})}

{pstd}
Die Histogramme des Einkommens für Männer und für Frauen überlagern sich nun, sind aber durch die Transparenz zu unterscheiden.
So sind auch die Einkommensintervalle mit höheren bzw. niedrigeren Häufigkeiten gut erkennbar.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker addedlines}
{title:11) Zusätzliche Linien}

{pstd}
Es ist häufig sinnvoll, neben den Häufigkeitsbalken weitere statistische Informationen im Histogramm anzuzeigen.
Beispiele für solche zusätzliche Statistiken wären das arithmetische Mittel oder der Median.
Das arithmetische Mittel einer Variable können wir uns mit dem Befehl {cmd:summarize} ausgeben lassen (hier für die Variable {cmd:rent}).

{phang2} {stata use "data1.dta", clear} {p_end}

{phang2} {stata summarize rent} {p_end}

{pstd}
Wir erhalten hier 602.85 (gerundet) als arithmetischen Mittelwert von {cmd:rent}.
Diesen Wert können wir jetzt mit der Option {cmd:line()} in einen {cmd:histogram}-Befehl einfügen.

{phang2} {stata histogram rent, frequency xline(602.85)} {p_end}

{pstd}
Wir sehen jetzt eine senkrechte getrichelte Linie beim Wert des arithmetischen Mittels, die allerdings von den Balken verdeckt ist.
Um diese Linie sichtbar zu machen, können wir die Balkenfarbe mit einer geringeren Deckkraft versehen, also transparent gestalten.

{phang2} {stata histogram rent, frequency xline(602.85) color(%30)} {p_end}

{pstd}
Wir haben hier die Option {cmd:color()} verwendet, um die Farbe mit einer Deckkraft von 30% zu versehen.

{pmore3}
{ul:Anmerkung:} In der Klammer steht eigentlich immer die Farbe, gefolgt von einer Modifikation der Deckkraft oder der Farbintensität. 
Der Eintrag {cmd:green%70} würde also bedeuten, dass die Farbe Grün mit einer 70%igen Deckkraft verwendet werden sollte.
Ein Eintrag {cmd:green*0.7} bedeutet dass der Farbton Grün mit einer modifizierten Farbintensität angezeigt wird.
Hierbei sind Werte von 0 (sehr hell) bis 255 (sehr dunkel) möglich, wobei der Wert 1 für den ursprünglichen Farbton steht.
Steht in die Klammer allerdings - wie in unserem Fall - nur die Deckkraft-Modifikation ({cmd:%30}), dann wird die automatisch genutzte Standardfarbe entsprechend verändert.
Das gleiche gilt auch für die Modifikation der Farbintensität.

{pstd}
Zur besseren Sichtbarkeit können wir auch die Eigenschaften der zusätzlichen Linie verändern.
Beispielsweise können wir sie mit der Sub-Option {cmd:lcolor(red)} als rote Linie anzeigen lassen.

{phang2} {stata histogram rent, frequency xline(602.85, lcolor(red)) color(%30)} {p_end}

{pstd}
Es kann während der Arbeit an einer Datenanalyse durchaus vorkommen, dass sich die Stichprobe verändert.
Das ist der Fall, wenn beispielsweise einzelne Beobachtungen ausgeschlossen werden müssen, der Datensatz in einer aktualisierten Version erscheint oder die Analyse aus bestimmten Gründen auf eine andere Untersuchungsgesamtheit bezogen wird.
Damit würden sich auch statistische Parameter verändern.
In diesem Fall müsste man das gesamte Do-File überprüfen, um diese Parameter - in unserem Fall das arithmetische Mittel - an die neue Stichprobe anzupassen.
Es würde eine erneute Ermittlung aller Parameter erfordern, wenn wir diese per Hand berechnet haben.

{pstd}
Eine automatisierte Ermittlung dieser Parameter, die sich bei jedem Durchlauf eines Do-Files den aktuell gültigen Wert berechnet, könnte hier Abhilfe schaffen.
Stata bietet hier die Funktion der sogenannten "stored results" an.
Jeder Befehl, der etwas berechnet, speichert seine Ergebnisse intern für den späteren Gebrauch ab.
Der Befehl {cmd: summarize} speichert demnach alle Ergebnisse ab, die in der Tabelle ausgegeben werden.
Eine Übersicht über alle gespeicherten Ergebnisse erhalten wir, wenn wir nach dem jeweiligen Befehl {cmd:return list} eingeben.

{phang2} {stata summarize rent} {p_end}

{phang2} {stata return list} {p_end}

{pstd}
In der Liste finden wir u.a. den Eintrag {cmd:r(mean)}, der den genauen Wert des arithmetischen Mittels enthält.
Dieser wird bei jedem Durchlauf mit den aktuellen Daten berechnet und intern gespeichert, so dass wir ihn nicht mehr berechnen, ablesen und von Hand in den {cmd:histogram}-Befehl eintragen müssen.
Indem wir nämlich statt des numerischen Wertes den Ausdruck {cmd:`r(mean)'} verwenden, stellen
 wir sicher, dass immer der aktuelle Wert des arithmetischen Mittels benutzt wird.
 
{phang2} {stata histogram rent, frequency xline(`r(mean)', lcolor(red)) color(%30)} {p_end}
 
{pstd}
Wichtig dabei ist, dass der Name des gespeicherten Ergebnisses - hier {cmd:r(mean)} - bei der Verwendung im Befehl eingefasst wird in ein einfaches schräges Anführungszeichen ({cmd:`}) und ein einfaches senkrechtes Anführungszeichen ({cmd:'}).

{pstd}
Wir können auch zusätzlich den Median in ein Histogramm einzeichnen.
Den Median bekommen wir auch mit dem Befehl {cmd:summarize}, allerdings nur zusammen mit der Option {cmd:detail}.

{phang2} {stata summarize rent, detail} {p_end}

{phang2} {stata return list} {p_end}

{pstd}
Der Name des Medians in den gespeicherten Ergebnissen ist {cmd:r(p50)}, den wir dann analog zum arithmetischen Mittel in einer weiteren Linie in die Grafik einzeichnen. {p_end}
{cmd}
        histogram rent, ///
		frequency ///
		xline(`r(mean)', lcolor(red)) ///
		xline(`r(p50)', lcolor(green)) ///
		color(%30)} {txt}
        {it:({stata iahf_hist_ex hist5de:Zum Starten hier klicken})}

{pstd}
Zusätzlich zu der roten Linie für das arithmetische Mittel findet sich jetzt eine grüne Linie, die den Median der Verteilung anzeigt.
Da der Median kleiner ist als das arithmetische Mittel, können wir den Schluss ziehen, dass die Verteilung der Variable {cmd:rent} rechtsschief (bzw. linkssteil) ist.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker classdata}
{title:12) Balkenbreite in Datensatz}

{pstd}
Die Breite der Balken in Histogrammen wird nach einer standardisierten Formel berechnet, die in der Regel keine ganzzahligen Intervallgrenzen liefert.
Auch wenn mit der {cmd:bin()}-Option die Zahl der Balken festgelegt wird, ist dies der Fall.
Die berechneten Intervallgrenzen werden nur temporär als interne Werte für die Diagrammkonstruktion benutzt.
Wenn nun Interesse daran besteht, mit den Intervallen des Diagramm weitere Analysen durchzuführen, wäre eine ordinale Variable hilfreich, die die klassierten Werte der Ursprungsvariablen enthält.
Schauen wir uns das am Beispiel der Variablen {cmd:ybirth} an.

{phang2} {stata use "data1.dta", clear} {p_end}

{phang2} {stata histogram ybirth, bin(20) frequency} {p_end}

{pstd}
Hier erzeugen wir ein Histogramm der Variable mit absoluten Häufigkeiten und legen die Balkenanzahl mit 20 fest.
Wir können mit der {cmd:autocode}-Funktion nun eine neue Variable generieren, die als Werte die jeweiligen Intervallobergrenzen enthält.
Diese Funktion benötigt als Argumente den Variablennamen, die Zahl der zu berechnenden Intervalle sowie das Maximum und das Minimum der Variable.
Die beiden letzteren erhalten wir automatisiert als gespeichertes Ergebnis ({cmd:r(min)} bzw. {cmd:r(max)}) durch die Ausführung des {cmd:summarize}-Befehls.

{phang2} {stata summarize ybirth} {p_end}

{phang2} {stata generate binybirth=autocode(ybirth,20,r(min),r(max))} {p_end}

{pstd}
Die {cmd:autocode}-Funktion erzeugt eine metrisch-skalierte Variable, die als Wert die jeweilige Intervallobergrenze enthält.

{phang2} {stata tabulate binybirth} {p_end}

{pstd}
Wir können dies überprüfen, indem wir uns eine Kreuztabelle zwischen der Ursprungsvariablen {cmd:ybirth} und der neuen Variablen mit den Obergrenzen {cmd:binybirth} ausgeben lassen.

{phang2} {stata tabulate ybirth binybirth} {p_end}

{pstd}
Im Folgenden kann die neue Variable ggfs. nach Umkodierung für weitere Analysen genutzt werden, um Auswertungen der einzelnen Klassen vorzunehmen.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker flexwidth}
{title:13) Histogramme mit variierenden Balkenbreiten}

{pstd}
Klassische Histogramme haben eine gleichmäßige Balkenbreite.
Es kann allerdings auch im Interesse von Forschenden sein, eine Anzahl von Balken mit jeweils gleichem Anteil von Beobachtungseinheiten grafisch darzustellen.
Dies wäre eine Analogie zu Quantilen, bei denen ja ebenfalls jeder Teil über die gleiche Anzahl von Beobachtungseinheiten verfügt.
Um ein solches Histogramm zu erstellen, müssen wir einen selbstgeschrieben Befehl eines Stata-Nutzers installieren.

{phang2} {stata ssc install eqprhistogram} {p_end}

{pstd}
Von Nutzer:innen geschriebene und geprüfte Befehle sind im Statistical Software Components (SSC) Archiv abgelegt und können jederzeit direkt aus Stata heraus installiert werden.
Dafür benötigt man lediglich den Namen des entsprechenden Befehls.
Sollten Sie den Befehl bereits vorher installiert haben, erscheint eine entsprechende Meldung im Ergebnisfenster.
Mit {cmd:help eqprhistogram} kann man dann die Hilfe aufrufen, wie bei den anderen Stata-Befehlen auch.
Die Bezeichnung {cmd:eqprhistogram} steht dabei als Abkürzung für "equal probability histogram".

{phang2} {stata eqprhistogram income} {p_end}

{pstd}
Standardmäßig werden hier acht Balken dargestellt, deren Fläche jeweils gleich groß ist.
Damit stellen sie je die gleiche Anzahl von Beobachtungen (in unserem Fall: Personen) dar.
Die Logik der Quartile, die auch in Boxplots ihre Anwendung findet, kann man hier anwenden, indem wir mit der {cmd:bin}-Option die Zahl der Balken auf 4 festlegen.

{phang2} {stata eqprhistogram income, bin(4)} {p_end}

{pstd}
Der erste Balken links umfasst genauso viele Personen wie der ganz rechte Balken, deckt aber einen viel breiteren Bereich von Werten der Einkommensskala ab.
In einem horizontalen Boxplot würde der rechte Balken einem langen Whisker mit einigen Ausreißern entsprechen und eine schiefe Verteilung andeuten.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker mirrored}
{title:14) Gespiegelte Histogramme}

{pstd}
Zur Gegenüberstellung von zwei Verteilungen können wir auch ein gespiegeltes Histogramm verwenden.
Hierzu müssen wir allerdings vorab den neuen Befehl {cmd:bihist} installieren - wie im Abschnitt 13 beschrieben - , da dieser nicht in Stata existiert, sondern ein selbstgeschriebener Befehl eines Stata-Nutzers ist.

{phang2} {stata ssc install bihist} {p_end}

{pstd}
Sollten Sie den Befehl bereits vorher installiert haben, erscheint eine entsprechende Meldung im Ergebnisfenster.

{phang2} {stata use "data1.dta", clear} {p_end}

{pstd}
Wir wollen uns in einem gespiegelten Histogramm die Einkommensverteilung von Männern und Frauen im Vergleich anschauen. 
Wie in Abschnitt 10 schließen wir wieder die Einkommen mit dem Wert {cmd:0} und die hohen Einkommen mit mehr als 100000$ von der Darstellung aus.

{phang2} {stata mvdecode income, mv(0=.)} {p_end}

{phang2} {stata replace income=. if income>100000} {p_end}

{pstd}
Der {cmd:bihist}-Befehl benötigt als Argumente lediglich die metrische Variable {cmd:income} und die dichotome Variable {cmd:sex}.

{phang2} {stata bihist income, by(sex)} {p_end}

{pstd}
Es ist mit {cmd:bihist} möglich, eine klassische Bevölkerungspyramide zu erstellen.
Hierzu müssen wir zunächst das Alter der Befragungspersonen berechnen, indem wir vom Befragungsjahr 2009 das Geburtsjahr ({cmd:ybirth}) abziehen.

{phang2} {stata generate age=2009-ybirth} {p_end}

{phang2} {stata bihist age, by(sex)} {p_end}

{pstd}
Bevölkerungspyramiden werden in der Regel vertikal dargestellt.
Die Befehl {cmd:bihist} erlaubt aber leider nur eine horizontale Darstellung. 
Auch lassen sich nicht die Lücken zwischen den Balken modifizieren.

{right:{help iahf_de_hist##inhalt:[zurück zur Übersicht]}}{break}



{hline}
{right:created 10/2025 by C. Brzinsky-Fay}
