*****************************************************************************
***** DPC-Webinar: Beautiful Stata -                                    *****
***** Wie man mit Stata publikationsfertige Grafiken erstellt           *****
*****                                                                   *****
***** 2) Scatter-Plots                                                  *****
*****                                                                   *****
***** Dr. Christian Brzinsky-Fay                                        *****
***** 12.12.2025                                                        *****
***** datasets: ex_coll.dta, allstates.dta, data1.dta                   *****
***** ados: fullpalette, vgsg                                           *****
*****************************************************************************
version 19
clear
set more off
cd "c:\webinar"
use "ex_coll.dta", clear
*~~~~~ Marker symbols
graph twoway scatter uerlt25 uergt25
graph twoway scatter uerlt25 uergt25, ///
	msize(small)
graph twoway scatter uerlt25 uergt25, ///
	msize(small) mlabel(country2)
graph twoway scatter uerlt25 uergt25, ///
	msize(medium) ///
	mlabel(country2) ///
	msymbol(T) ///
	mlabsize(tiny) ///
	mlabcolor(black)
graph twoway scatter uerlt25 uergt25, ///
	msymbol(oh) msize(small) mcolor(gray) ///
	mlabel(country2) mlabsize(tiny) mlabcolor(black)
*~~~~~ Zwei Datenreihen: Beispiel 1
use "data1.dta", clear
generate rent_w = rent if state <= 9
generate rent_e = rent if state >= 10 & state < .
graph twoway scatter rent_w rent_e size
graph twoway scatter rent_w rent_e size, ///
	msize(small medium) msymbol(o Oh)
*~~~~~ Zwei Datenreihen: Beispiel 2
use "ex_coll.dta", clear
separate uerlt25, by(country2)	
graph twoway scatter uerlt25* uergt25, ///
	legend(off)
forvalues num =1/30 {
	graph twoway scatter uerlt25 uerlt25`num' uergt25
	graph export "uer`num'.emf", replace
}
*~~~~~ Overlaying
use "ex_coll.dta", clear
graph twoway ///
	(lfit uerlt25 uergt25) ///
	(scatter uerlt25 uergt25)
graph twoway ///
	(lfitci uerlt25 uergt25) ///
	(scatter uerlt25 uergt25, msize(small) mcolor(sienna)), ///
		legend(off) ///
		ytitle("unemployment rate (15-24), OECD") ///
		title("Youth & Adult Unemployment")
*~~~~~ Achsen-Label
use "allstates.dta", clear
graph twoway scatter ownhome propval100
graph twoway scatter ownhome propval100, ///
	xlabel(0(10)100) ///
	ylabel(10(10)90)
graph twoway scatter ownhome propval100, ///
	xlabel(#4) ///
	ylabel(#8)
graph twoway scatter ownhome propval100, ylabel(none)
graph twoway scatter ownhome propval100, ylabel(minmax)
graph twoway scatter ownhome propval100, ///
	ylabel(, nogrid)
*~~~~~ Zusätzliche Linien
use "allstates.dta", clear
graph twoway scatter ownhome propval100
graph twoway scatter ownhome propval100, ///
	yline(55)
graph twoway scatter ownhome propval100, ///
	yline(55 75) yline(65, lcolor(erose))
graph twoway scatter ownhome propval100, ///
	yline(55 75) yline(65, lcolor(erose) lpattern(solid))
graph twoway scatter ownhome propval100, ///
	yline(55 75) yline(65, lwidth(thick))
*~~~~~ by-Option
use "allstates.dta", clear
graph twoway scatter ownhome propval100, by(nsw)
graph twoway scatter ownhome propval100, ///
	by(nsw, total)
graph twoway scatter ownhome propval100, ///
	by(nsw, total compact)
*~~~~~ Streudiagramm final
use "ex_coll.dta", clear
generate yuer_ger=uerlt25 if country2==9
generate yuer_nl=uerlt25 if country2==19
generate yuer_grc=uerlt25 if country2==10
generate yuer_pol=uerlt25 if country2==22
generate yuer=uerlt25 if !inlist(country,9,10,19,22)
graph twoway ///
	(fpfitci uerlt25 uergt25, ///
		acolor(gold%50)) ///
	(scatter yuer uergt25, ///
		msize(vsmall) ///
		mcolor(gs12%50)) ///
	(scatter yuer_ger uergt25, ///
		msymbol(i) ///
		mlabel(country2) ///
		mlabsize(vsmall) ///
		mlabposition(0) ///
		mlabcolor(maroon) ///
		msize(tiny)) ///
	(scatter yuer_nl uergt25, ///
		msymbol(i) ///
		mlabel(country2) ///
		mlabsize(vsmall) ///
		mlabposition(0) ///
		mlabcolor(ebblue) ///
		msize(tiny)) ///
	(scatter yuer_grc uergt25, ///
		msymbol(i) ///
		mlabel(country2) ///
		mlabsize(vsmall) ///
		mlabposition(0) ///
		mlabcolor(green) ///
		msize(tiny)) ///
	(scatter yuer_pol uergt25, ///
		msymbol(i) ///
		mlabel(country2) ///
		mlabsize(vsmall) ///
		mlabposition(0) ///
		mlabcolor(lavender) ///
		msize(tiny)), ///
			ytitle("youth unemployment rate (15-24), OECD") ///
			xlabel(0(2)18, grid) ///
			legend(off) ///
			title("Relation Adult & Youth Unemployment in OECD", span) ///
			graphregion(color(white)) ///
			xsize(6)

