{smcl}
{*:author: C. Brzinsky-Fay, started 07/2025, datasets: auto.dta, sp500.dta, eplbargfix.dta}

{center:{ul on}{yellow:Die colorvar()-Option für die farbliche Darstellung von Drittvariablen}{ul off}}

{center:{hi:Christian Brzinsky-Fay, DPC Software}}
{center:{it:Kontakt:christian.brzinsky-fay@dpc-software.de}}}



{hline}

{pstd}
Hier demonstriere ich Ihnen, wie Sie in verschiedenen {cmd:twoway}-Diagrammen die Marker farblich nach den Werten einer dritten Variable unterscheiden können. 
Die hierfür verwendete Option {cmd:colorvar()} ist für Balken-, Streu- und Liniendiagramme, Dot-Plots sowie für weitere Diagrammtypen verfügbar.

{pstd}
Dieses Feature wurde in Stata 18 neu eingeführt und in StataNow auf weitere Grafiktypen ausgeweitet.

{hline}

{marker inhalt}
{pstd}
{title:{yellow:Übersicht}}

{phang2} {help colorvar##intro:1) Ein einfaches Streudiagramm}{break} {p_end}

{phang2} {help colorvar##drittevar:2) Eine dritte Variable}{break} {p_end}

{phang2} {help colorvar##diskret:3) Wenn die Drittvariable diskret ist}{break} {p_end}

{phang2} {help colorvar##kategorial:4) Wenn die Drittvariable kategorial ist}{break} {p_end}

{phang2} {help colorvar##farben:5) Die Verwendung von Farben für Drittvariablen}{break} {p_end}

{phang2} {help colorvar##balkencut:6) Ein einfaches Balkendiagramm}{break} {p_end}

{phang2} {help colorvar##balkenfarb:7) Ein weiteres Balkendiagramm}{break} {p_end}

{phang2} {help colorvar##dotchart:8) Ein Beispiel für Dot-Charts}{break} {p_end}

{hline}

{marker intro}
{title:1) Ein einfaches Streudiagramm}

{pstd}
Wir laden zunächst den berühmten Stata-Beispieldatensatz {cmd:auto.dta}, der ein paar Informationen zu verschiedenen Autotypen enthält. 
Das Streudiagramm zeigt die Kovariation der zwei Variablen Spritverbrauch ({cmd:mpg}) und Preis ({cmd:price}). 

{phang2} {stata sysuse "auto.dta", clear} {p_end}

{pstd}
Die Merkmale sind hier in amerikanischen Einheiten gemessen, also der Spritverbrauch in Meilen pro Gallone Benzin bzw. der Preis in Dollar.

{phang2} {stata graph twoway scatter mpg price} {p_end}

{pstd}
Man kann einen negativen Zusammenhang zwischen beiden Variablen erkennen: je höher der Preis, desto niedriger die Reichweite, d.h. je höher der Preis, desto höher der Spritverbrauch.

{right:{help colorvar##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker drittevar}
{title:2) Eine dritte Variable}

{pstd}
Der Zusammenhang zwischen Preis und Verbrauch wird sicherlich noch von anderen Eigenschaften eines Autotyps beeinflusst. Es wäre beispielsweise denkbar, dass auch das Gewicht eines Autos Einfluss auf den Verbrauch hat. 

{pstd}
Die entsprechende Variable {cmd:weight} schauen wir uns zunächst mit {cmd:summarize} an.

{phang2} {stata summarize weight} {p_end}

{pstd}
Auch hier hat die Variable wieder eine amerikanische Einheit, und zwar amerikanische Pfund (1 Pfund = ca. 0.45kg).

{pstd}
Wir stellen dann den Zusammenhang zwischen den beiden Ausgangsvariablen ({cmd:mpg} und {cmd:price}) unter Einbeziehung einer dritten Variable ({cmd:weight}) grafisch in dem gleichen Streudiagramm mit differenzierten Farben dar.

{phang2} {stata graph twoway scatter mpg price, colorvar(weight)} {p_end}

{pstd}
Auf der rechten Seite erhalten wir jetzt eine Skala, die automatisch die (kontinuierliche) Drittvariable klassiert, also in Intervalle einteilt und diesen kontrastreiche Farben zuordnet. 

{pstd}
Die leichtesten Autotypen (bis 2000 Pfund, ca. 907kg) sind in Dunkelblau dargestellt, gefolgt von Türkis und Grün, während die schwersten Autotypen (ab 4000 Pfund, ca. 1814kg) die Farbe Gelb erhalten.

{pstd}
Wir können hier feststellen, dass die leichteren Autotypen (blau) die größte Reichweite (Meilen pro Gallone Benzin), d.h. den geringsten Verbrauch haben, und dabei im Preis relativ wenig variieren. 
Die schweren Autotypen (gelb) haben alle eine geringe Reichweite, d.h. einen hohen Verbrauch, variieren dafür aber beträchtlich im Preis.

{right:{help colorvar##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker diskret}
{title:3) Wenn die Drittvariable diskret ist}

{pstd}
Wenn eine Variable nur ganzzahlige (oder gerundete) Werte annimmt, wird sie als diskrete Variable bezeichnet.
Beispielsweise könnten wir uns die Gewichtsvariable auch mit auf Tausender gerundeten Werten vorstellen, was wir mit einer Umrechnung erreichen.

{phang2} {stata generate weight2=int(weight/1000)*1000} {p_end}

{pstd}
Für die neue diskrete Variable {cmd:weight2} können nun keine automatischen Intervalle gebildet werden,
da sie ja nur die Werte 1000, 2000, 3000 oder 4000 annehmen kann.

{phang2} {stata tabulate weight2} {p_end}

{phang2} {stata graph twoway scatter mpg price, colorvar(weight2) colordiscrete} {p_end}

{pstd}
Durch die Angabe der Option {cmd:colordiscrete} teilen wir Stata mit, dass hier keine Intervalle für die Drittvariable gebildet werden sollen.

{right:{help colorvar##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker kategorial}
{title:4) Wenn die Drittvariable kategorial ist}

{pstd}
Ein diskrete Variable hat zwar nur eine begrenzte Zahl an Ausprägungen, ist aber trotz allem metrisch skaliert.
Die Ausprägungen (1000, 2000, 3000 bzw. 4000) repräsentieren daher Zahlen mit vergleichbaren Abständen.
Liegt eine Drittvariable vor, die nominal (bzw. kategorial) skaliert ist, ist der Zahlenwert nicht von Bedeutung, sondern repräsentiert nur unterscheidbare Kategorien.
In der Legende der Drittvariablen sollten demnach die Kategorien benannt werden. 

{pstd}
Ein Beispiel wäre hier die Variable {cmd:foreign}, die kennzeichnet, ob ein Autotyp aus den USA (Zahlenwert 0, domestic) oder aus dem Ausland (Zahlenwert 1, foreign) kommt.

{phang2} {stata tabulate foreign} {p_end}
{phang2} {stata tabulate foreign, nolabel} {p_end}

{pstd}
Das Streudiagramm mit allen drei Variablen wird wie im vorangegangenen Beispiel erzeugt, benötigt aber zwei zusätzliche Optionen, um die Legende entsprechend zu formatieren.

{phang2} {stata graph twoway scatter mpg price, colorvar(foreign) colordiscrete coloruseplegend zlabel(, valuelabel)}

{pstd}
Die Option {cmd:coloruseplegend} definiert die kategoriale Legende, während die Option {cmd:zlabel(, valuelabel)} anstelle der internen Zahlenwerte die zugeordneten Wertelabel der Variable {cmd:foreign} für die Darstellung verwendet.

{right:{help colorvar##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker farben}
{title:5) Die Verwendung von Farben für Drittvariablen}

{phang2} {stata graph twoway scatter mpg price, colorvar(weight2) colordiscrete} {p_end}

{pstd}
Die Farben werden bei Anwendung der {cmd:colorvar}-Option automatisch berechnet, können aber auch von Hand gesteuert werden.
Hierfür können wir die {cmd:colorstart}- und die {cmd:colorend}-Optionen verwenden, mit denen die erste und die letzte Farbe bestimmt werden.
Die Farben dazwischen werden in jeweils gleichen Abständen errechnet.

{phang2} {stata graph twoway scatter mpg price, colorvar(weight2) colordiscrete colorstart(red) colorend(green)} {p_end}

{pstd}
Da den vorgegebenen Farbbezeichnungen (z.B. {cmd:red}, {cmd:green}) konkrete Farbkodierungen zugrunde liegen (z.B. RGB- oder CMYK-Codes), ist es empfehlenswert, diese auch für die Farbdefinitionen zu verwenden.

{phang2} {stata graph twoway scatter mpg price, colorvar(weight2) colordiscrete colorstart(255 0 0) colorend(255 0 255)} {p_end}

{pstd}
Die {cmd:colorvar}-Option ist in Stata 18 (bisher) für Streu- und Balkendiagramme anwendbar. Mit StataNow steht sie auch für Liniendiagramme zur Verfügung.

{right:{help colorvar##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker balkencut}
{title:6) Ein einfaches Balkendiagramm}

{pstd}
Für ein zweites Beispiel laden wir jetzt einen anderen Stata-Beispieldatensatz, der Informationen über den täglichen Preis einer Aktie sowie über deren Preisveränderungen enthält.

{phang2} {stata sysuse "sp500.dta", clear} {p_end}

{pstd}
Wir erstellen hier ein Balkendiagramm, das uns die täglichen Veränderungen des Aktienpreises als positiven bzw. negativen Balken zeigt.

{phang2} {stata graph twoway bar change date} {p_end}

{pstd}
Als zusätzlich Drittvariable wollen wir in das Diagramm noch das tägliche Handelvolumen der Aktie einbringen. Dies können wir wieder mit der {cmd:}colorvar}-Option tun.

{phang2} {stata graph twoway bar change date, colorvar(volume)} {p_end}

{pstd}
Da die Drittvariable kontinuierlich ist, wird sie automatisch in farblich unterscheidbare Kategorien eingeteilt. Wir können diese Einteilung mit der {cmd:colorcuts}-Option beeiflussen. Als Parameter geben wir den Start- und den Endwert sowie dazwischen die Intervalle der Klassengrenzen an.

{phang2} {stata graph twoway bar change date, colorvar(volume) colorcuts(5000(10000)25000)} {p_end}

{right:{help colorvar##inhalt:[zurück zur Übersicht]}}{break}

{hline}

{marker balkenfarb}
{title:7) Ein weiteres Balkendiagramm}

{pstd}
Für ein zweites Beispiel laden wir jetzt einen anderen Datensatz, der Informationen über den Beschäftigungsschutz (index of employment protection legislation, epl), 
den Anteil der durch Gewerkschaften vertretenden Beschäftigten (bargaining coverage, bargcov) sowie den Anteil von befristet Beschäftigten (fixed-term employed, fixed) in OECD-Ländern enthält.

{phang2} {stata use "eplbargfix.dta", clear} {p_end}

{pstd}
Wir erstellen hier ein Balkendiagramm, das uns die Entwicklung des Beschäftigungsschutzes in den OECD-Ländern über die Jahre 1990-2019 zeigt.

{phang2} {stata graph twoway bar epl year} {p_end}

{pstd}
Der Index für Beschäftigungsschutz, der von 0 (niedrig) bis 6 (hoch) reicht nimmt über die angezeigten Jahre stetig ab.

{pstd}
Als Drittvariable wollen wir in das Diagramm noch den Anteil an befristet Beschäftigten in den jeweiligen Jahren aneigen. 
Dies können wir wieder mit der {cmd:colorvar}-Option tun.

{phang2} {stata graph twoway bar epl year, colorvar(fixed)} {p_end}

{pstd}
Obwohl die Drittvariable wieder kontinuierlich ist, wird sie automatisch in sinnvolle Kategorien eingeteilt. 
Wir können allerdings die Farben ein wenig besser mit Farbabstufungen gestalten.
Hierfür verwenden wir die Optionen {cmd:colorlist} und {cmd:colorfillonly}.
Die Option {cmd:lcolor} ist eine Standard-Option und setzt die Linienfarbe auf weiß.

{phang2} {stata graph twoway bar epl year, colorvar(fixed) colorlist(cranberry*0.1 cranberry*0.4 cranberry*0.7 cranberry) colorfillonly lcolor(white)} {p_end}

{pstd}
Mit der {cmd:colorlist}-Option können wir die Farben der Kategorien bzw. Intervalle der Drittvariablen angeben.
Hier sind für vier Kategorien vier verscheidene Helligkeitsstufen der Farbe {cmd:cranberry} definiert.
Die Option {cmd: colorfillonly} gibt an, dass diese Farbauswahl nur auf die Füllung der jeweiligen Marker (hier: Balken) angewandt werden soll.

{right:{help colorvar##inhalt:[zurück zur Übersicht]}}{break}

{marker dotchart}
{title:8) Ein Beispiel für Dot-Charts}

{pstd}
Wir verwenden den gleichen Datensatz für ein Beispiel zur Verwendung der colorvar-Option bei Dot-Charts (Punktdiagramm).
Als y-Variable verwenden wir jetzt bargaining coverage anstelle des Beschäftigungindexes.

{phang2} {stata graph twoway dot bargcov year, colorvar(fixed) colorlist(emerald*0.1 emerald*0.4 emerald*0.7 emerald) colorfillonly lcolor(white)} {p_end}

{pstd}
Die verwendeten Optionen sind die gleichen wie im Beispiel zuvor (mit Ausnahme der Farbe).
Sie beziehen sich hier nur auf die Marker der Dot-Charts.

{right:{help colorvar##inhalt:[zurück zur Übersicht]}}{break}


{hline}
{right:created 07/2025 by C. Brzinsky-Fay}
