*****************************************************************************
***** DPC-Webinar: Beautiful Stata -                                    *****
***** Wie man mit Stata publikationsfertige Grafiken erstellt           *****
*****                                                                   *****
***** 4) Box-Plots & Violin-Plots                                       *****
*****                                                                   *****
***** Dr. Christian Brzinsky-Fay                                        *****
***** 12.12.2025                                                        *****
***** datasets: unempdur1.dta, data1.dta, uegdp1.dta, isei2.dta         *****
***** ados: violinplot, stripplot, dstat, moremata, palettes, colrspace *****
*****************************************************************************
version 19
set more off
capture log close
clear
ssc install stripplot, replace
ssc install violinplot, replace
ssc install dstat, replace
ssc install moremata, replace
ssc install palettes, replace
ssc install colrspace, replace
cd "c:\webinar"
*****************
**# Box-Plots #**
*****************
*~~~~~ Box-Plots: Basics
use "unempdur1.dta", clear
graph box ued_gt1y
graph hbox ued_gt1y
graph hbox ued_gt1y, medtype(marker)
graph box ued_gt1y, over(year)
graph box ued_gt1y, over(year, label(alternate))
graph box ued_gt1y, over(year, label(angle(45)))
graph hbox ued_gt1y, over(year)
*~~~~~ Box-Plots: Ausreißer
use "data1.dta", clear
graph hbox income, over(state)
graph hbox income, over(state) nooutsides
*~~~~~ Box-Plots: Sortierung
use "unempdur1.dta", clear
graph hbox ued_gt1y, over(country)
by country, sort: egen meanued=mean(ued_gt1y)
graph hbox ued_gt1y, over(country, sort(meanued))
graph hbox ued_gt1y, ///
	over(country, sort(meanued)) ///
	nooutsides
graph hbox ued_gt1y, ///
	over(country, sort(meanued) label(labsize(vsmall))) ///
	nooutsides ///
	note("")
*~~~~~ Box-Plots: over-Option(en)
graph hbox ued_gt1y, ///
	over(country, sort(meanued) label(labsize(vsmall))) ///
	over(welfreg) ///
	nofill ///
	nooutsides ///
	note("")
*~~~~~ Box-Plots: Balken-Abstände
graph hbox ued_gt1y, ///
	over(country, sort(meanued) label(labsize(vsmall)) gap(40)) ///
	over(welfreg) ///
	nofill ///
	nooutsides ///
	note("")
graph hbox ued_gt1y, ///
	over(country, sort(meanued) label(labsize(vsmall)) gap(40)) ///
	over(welfreg) ///
	nofill ///
	nooutsides ///
	note("") ///
	outergap(200)
*~~~~~ Verteilungsgrafiken: Balkendiagramm, Histogramm, Box-Plot, & Strip-Plots
use "data1.dta", clear
graph hbar rent, ///
	ytitle("") ///
	ylabel(0(1000)5000) ///
	name(barrent, replace) ///
	nodraw
histogram rent, ///
	ylabel(none) ///
	ytitle("") ///
	xlabel(0(1000)5000) ///
	xtitle("") ///
	name(histrent, replace) ///
	nodraw
graph hbox rent, ///
	ytitle("") ///
	ylabel(0(1000)5000) ///
	name(boxrent, replace) ///
	nodraw
stripplot rent, ///
	ytitle("") ///
	xlabel(0(1000)5000) ///
	jitter(5) ///
	mcolor(%15) ///
	name(striprent, replace) ///
	nodraw
graph combine barrent histrent boxrent striprent, ///
	cols(1) ///
	ycommon
*~~~~~ Box-Plots: Einfärben einzelner Boxen
use "unempdur1.dta", clear
generate ued1y_oth=ued_gt1y if inlist(country,1,4,12,15,20,21,27,29,30)
generate ued1y_eu=ued_gt1y if inlist(country,2,3,5,6,7,8,9,10,11,13,14,17,19,22,23,24,25,26,34,35,36,37,38,39,40,41,43)
by country, sort: egen meanued=mean(ued_gt1y)
graph hbox ued1y_eu ued1y_oth, ///
	over(country, sort(meanued) label(labsize(vsmall)) gap(40)) ///
	over(welfreg) ///
	nofill ///
	nooutsides ///
	note("") ///
	box(1, color(teal)) ///
	box(2, color(sand))
*~~~~~ Box-Plots: Legende
graph hbox ued1y_eu ued1y_oth, ///
	over(country, sort(meanued) label(labsize(vsmall)) gap(40)) ///
	over(welfreg) ///
	nofill ///
	nooutsides ///
	note("") ///
	box(1, color(teal)) ///
	box(2, color(sand)) ///
	legend( ///
		position(2) ring(0) ///
		cols(1) symxsize(5) ///
		label(1 "EU") ///
		label(2 "non-EU"))
*~~~~~ Box-Plots: Beispiel-Grafik
use "uegdp1.dta", clear
by country, sort: egen meangdpg=mean(gdpgrowth)
generate gdpeu1=gdpgrowth if inlist(country,3,6,8,9,10,13,14,17,19,23,25,29)
generate gdpeu2=gdpgrowth if inlist(country,2,5,7,11,22,24,26,35,36,37,38,39,41)
generate gdpeu3=gdpgrowth if inlist(country,34,40, 43)
graph box gdpeu*, ///
	over(country2, sort(meangdpg) label(labsize(vsmall))) ///
	over(region, gap(300)) ///
	nofill ///
	nooutsides ///
	note("") ///
	box(1, color(navy)) ///
	box(2, color(dkgreen)) ///
	box(3, color(olive)) ///
	yline(0, lcolor(maroon*0.5)) ///
	ytitle("GDP growth rate") ///
	legend( ///
		position(3) cols(1) symxsize(5) ///
		label(1 "EU 1990") ///
		label(2 "EU 2005") ///
		label(3 "EU 2015")) ///
	title("GDP Growth Rates 1990-2016") ///
	subtitle("by country, region & EU accession period") ///
	xsize(10)
********************
**# Violin-Plots #**
********************
*~~~~~ Violin-Plots: Basics
use "isei2.dta", clear
violinplot isei
violinplot isei, left
violinplot isei, right
violinplot isei, vertical
violinplot isei, vertical ysize(8)
violinplot isei, vertical ysize(8) mean
violinplot isei, vertical ysize(8) nobox
violinplot isei, vertical ysize(8) noline
violinplot isei, vertical ysize(8) fill
violinplot isei, vertical ysize(8) fill color(forest_green)
*~~~~~ Violin-Plots: over-Option & Farben
use "isei2.dta", clear
violinplot isei, by(sex) vertical fill 
violinplot isei, over(sex) vertical fill 
violinplot isei, ///
	over(sex) vertical fill(select(2))
violinplot isei, ///
	over(sex) vertical fill color(maroon ebblue)
violinplot isei, ///
	over(origin) vertical fill color(gold forest_green)
*~~~~~ Exkurs: Präsentationstechniken
violinplot isei, ///
	over(edulevel) vertical fill(select(1)) color(lavender)
graph export "violin01.emf", replace
violinplot isei, ///
	over(edulevel) vertical fill(select(2)) color(lavender)
graph export "violin02.emf", replace
violinplot isei, ///
	over(edulevel) vertical fill(select(3)) color(lavender)
graph export "violin03.emf", replace
*~~~~~ Violin-Plot: Beispiel-Grafik
use "isei1.dta", clear
violinplot isei, ///
	vertical ///
	fill ///
	over(sex) ///
	color(forest_green maroon) ///
	ytitle("") ///
	ylabel(, labsize(small)) ///
	ymlabel( ///
		16 "Reinigungspersonal" ///
		24 "Hilfsarbeiter:innen" ///
		28 "Maurer:innen" ///
		34 "Industriearbeiter:innen" ///
		43 "Krankenhelfer:innen, Kindergärtner:innen" ///
		54 "Techniker:innen, Büroangestellte" ///
		66 "Grundschullehrer:innen, Sozialwissenschaftler:innen" ///
		71 "Statistiker:innen, Soziolog:innen" ///
		85 "Zahnärzt:innen" ///
		90 "Richter:innen") ///
	title("{bf:I}nternational {bf:S}ocio-{bf:E}conomic {bf:I}ndex of Occupational Status", ///
		span margin(0 0 5 0))