*****************************************************************************
***** DPC-Webinar: Beautiful Stata -                                    *****
***** Wie man mit Stata publikationsfertige Grafiken erstellt           *****
*****                                                                   *****
***** 5) Farben                                                         *****
*****                                                                   *****
***** Dr. Christian Brzinsky-Fay                                        *****
***** 12.12.2025                                                        *****
***** datasets: data1.dta, citytemp.dta, studis.dta                     *****
***** ados: fullpalette, vgsg                                           *****
*****************************************************************************
version 19
set more off
capture log close
clear
ssc install full_palette
net from http://www.stata-press.com/data/vgsg
net install vgsg
cd "c:\webinar"
*~~~~~ Farben: Überblick
help colorstyle
graph query colorstyle
palette color dkgreen teal
clear
full_palette
vgcolormap
*~~~~~ Farben: Grundlagen
use "data1.dta", clear
histogram lsat, ///
	discrete frequency ///
	color(blue)
histogram lsat, ///
	discrete frequency ///
	color("0 0 255")
histogram lsat, ///
	discrete frequency ///
	color("255 255 0 0")
histogram lsat, ///
	discrete frequency ///
	color("hsv 240 1 1")
*~~~~~ Hue color Wheel
clear
set obs 12
generate id=_n
generate slice=30
separate slice, by(id)
drop slice
graph pie slice*, angle(105) ///
	pie(1, color(hsv 0 1 1)) ///
	pie(2, color(hsv 30 1 1)) ///
	pie(3, color(hsv 60 1 1)) ///
	pie(4, color(hsv 90 1 1)) ///
	pie(5, color(hsv 120 1 1)) ///
	pie(6, color(hsv 150 1 1)) ///
	pie(7, color(hsv 180 1 1)) ///
	pie(8, color(hsv 210 1 1)) ///
	pie(9, color(hsv 240 1 1)) ///
	pie(10, color(hsv 270 1 1)) ///
	pie(11, color(hsv 300 1 1)) ///
	pie(12, color(hsv 330 1 1)) ///
	plabel(1 "0") ///
	plabel(2 "30") ///
	plabel(3 "60") ///
	plabel(4 "90") ///
	plabel(5 "120") ///
	plabel(6 "150") ///
	plabel(7 "180") ///
	plabel(8 "210") ///
	plabel(9 "240") ///
	plabel(10 "270") ///
	plabel(11 "300") ///
	plabel(12 "330") ///
	legend(off) ///
	title("360-degree hue color wheel")
*~~~~~ Beispiel für Schleifen über Farbtöne
use "data1.dta", clear
forvalues red=0(16)255 {
	histogram lsat, discrete frequency color("`red' 0 0")
	graph export "histcol_`red'_0_0.jpg", replace
}
forvalues value=0(16)255 {
	local value2=255-`value'
	histogram lsat, discrete frequency color("`value' `value2' 0")
	graph export "histcol_`value'_`value2'_0.jpg", replace
}
*~~~~~ Transparenz
use "citytemp.dta", clear
graph twoway scatter heatdd cooldd
graph twoway scatter heatdd cooldd, msymbol(o) msize(vsmall)
graph twoway scatter heatdd cooldd, mcolor(%40)
graph twoway scatter heatdd cooldd, mcolor(%10)
graph twoway scatter heatdd cooldd, mcolor(black%10)
graph twoway scatter heatdd cooldd, mcolor(gs5%10)
*~~~~~ Farben & Daten: Beispiel 1
use "studis.dta", clear
graph bar, ///
	over(freqsport) asyvars ///
	bar(1, color(maroon*0.5)) ///
	bar(2, color(maroon*0.6)) ///
	bar(3, color(maroon*0.7)) ///
	bar(4, color(maroon*0.8)) ///
	bar(5, color(maroon*0.9))
*~~~~~ Farben & Daten: Beispiel 2
preserve
tabulate freqsport, generate(sportdum)
graph bar sportdum*, ///
	bar(1, color(sienna*0.2)) ///
	bar(2, color(sienna*0.4)) ///
	bar(3, color(sienna*0.6)) ///
	bar(4, color(sienna*0.8)) ///
	bar(5, color(sienna)) ///
	legend( ///
		label(1 "gar nicht") ///
		label(2 "<1x pro Woche") ///
		label(3 "1x pro Woche") ///
		label(4 "mehrmals pro Woche") ///
		label(5 "täglich"))
restore
*~~~~~ Farben & Daten: Beispiel 3
replace freqparty=round(freqparty,1)
histogram freqparty if geschlecht2==1, ///
	frequency discrete color(emerald%50) ///
	addplot(histogram freqparty if geschlecht2==2, ///
		frequency discrete color(dkorange%50)) ///
	legend(label(1 "Frauen") label(2 "Männer"))
*~~~~~ Farbvariation nach Kategorien
use "data1.dta", clear
graph twoway scatter rent income if inrange(income,1,100000) & rent<2000, ///
	colorvar(yedu)
graph twoway scatter rent income if inrange(income,1,100000) & rent<2000, ///
	colorvar(yedu) colorlist(blue%25 yellow%25 yellow%25 yellow%25 yellow%25)
graph twoway scatter rent income if inrange(income,1,100000) & rent<2000, ///
	colorvar(yedu) colorlist(blue%25 yellow%25 yellow%25 yellow%25 yellow%25)


	
	

