*****************************************************************************
***** DPC-Webinar: Beautiful Stata -                                    *****
***** Wie man mit Stata publikationsfertige Grafiken erstellt           *****
*****                                                                   *****
***** 8) Tipps & Tricks                                                 *****
*****                                                                   *****
***** Dr. Christian Brzinsky-Fay                                        *****
***** 12.12.2025                                                        *****
***** datasets: data1.dta, allstates.dta, uegdp1.dta, epl1.dta          *****
***** ados: fabplot                                                     *****
*****************************************************************************
version 19
set more off
capture log close
clear
ssc install fabplot, replace
cd "c:\webinar"
*****************************
**# Deckkraft/Transparenz #**
*****************************
*~~~~~ Beispiel 1
use "data1.dta", clear
keep if hhinc>0 & hhinc<100000
graph twoway scatter hhinc rent
graph twoway scatter hhinc rent, mcolor(stc1%20)
*~~~~~ Beispiel 2
use "data1.dta", clear
keep if income>0 & income<100000
histogram income, percent width(1000) by(sex, cols(1))
histogram income if sex==1, ///
	frequency ///
	color(ebblue%50) ///
	width(1000) ///
	addplot(histogram income if sex==2, ///
		frequency color(gold%50) width(1000)) ///
	legend(off)
******************************
**# Gewichtete Datenpunkte #**
******************************
use "allstates.dta", clear
graph twoway scatter ownhome propval100
graph twoway scatter ownhome propval100 [aweight=popden]
graph twoway scatter ownhome propval100 [aweight=popden], ///
	msize(small) mcolor(emerald%30) mlcolor(none)
************************
**# Label als Marker #**
************************
use "allstates.dta", clear
graph twoway ///
	(scatter divorced urban) ///
	(lfit divorced urban)
graph twoway ///
	(scatter divorced urban, mlabel(stateab)) ///
	(lfit divorced urban)
graph twoway ///
	(scatter divorced urban, mlabel(stateab) mlabposition(12)) ///
	(lfit divorced urban)
graph twoway ///
	(scatter divorced urban, mlabel(stateab) mlabposition(0)) ///
	(lfit divorced urban)
graph twoway ///
	(scatter divorced urban, mlabel(stateab) mlabposition(0) msymbol(i)) ///
	(lfit divorced urban)
****************************
**# Separate Datenreihen #**
****************************
use "uegdp1.dta", clear
graph twoway ///
	(lfit uer15_19 gdpgrowth) ///
	(scatter uer15_19 gdpgrowth, mcolor(black%20)), ///
		ytitle("Youth Unemployment Rate (15-19 Years)") ///
		legend(off)
separate uer15_19, by(country) generate(yuer_)
labelbook lbcoun2
graph twoway ///
	(lfit uer15_19 gdpgrowth, lcolor(black)) ///
	(scatter uer15_19 gdpgrowth, mcolor(gs12%30)) ///
	(lfit yuer_10 gdpgrowth, lcolor(green)) ///
	(scatter yuer_10 gdpgrowth, ///
		mlabel(country2) ///
		mlabsize(vsmall) ///
		mlabposition(0) ///
		mlabcolor(green) ///
		msymbol(i)) ///
	(lfit yuer_9 gdpgrowth, lcolor(red)) ///
	(scatter yuer_9 gdpgrowth, ///
		mlabel(country2) ///
		mlabsize(vsmall) ///
		mlabposition(0) ///
		mlabcolor(red) ///
		msymbol(i)), ///
			ytitle("Youth Unemployment Rate (15-19 Years)") ///
			legend(off)
*************************************
**# Spaghetti, Paella & Fab-Plots #**
*************************************
*~~~~~ Beispiel 1: Spaghetti-Problem
use "epl1.dta", clear
separate epl1, by(country) generate(epl_) shortlabel
graph twoway line epl_* year, ///
	legend(position(3) ///
		cols(1) ///
		size(vsmall))
*~~~~~ unzufriedenstellende Lösung
graph twoway line epl1 year, ///
	by(country) ytitle("EPL index, version 1")
*~~~~~ bessere Lösung: Front-and-back-Plot (Fab-Plot)
fabplot line epl1 year, ///
	by(country) ///
	ytitle("EPL index, version 1")
fabplot line epl1 year, ///
	by(country) ///
	ytitle("EPL index, version 1") ///
	front(connect)
fabplot line epl1 year, ///
	by(country) ///
	ytitle("EPL index, version 1") ///
	front(scatter)
fabplot line epl1 year, ///
	by(country) ///
	ytitle("EPL index, version 1") ///
	frontopts(lwidth(thick))
fabplot line epl1 year, ///
	by(country) ///
	ytitle("EPL index, version 1") ///
	frontopts(lwidth(medthick) lcolor(red))
*~~~~~ Fab-Plot mit ausgewählten Datenreihen
fabplot line epl1 year ///
	if country==9 | country==19 | country==23 | country==29, ///
	by(country) ///
	ytitle("EPL index, version 1")
generate wanted=inlist(country, 9, 19, 23, 29)
fabplot line epl1 year, ///
	by(country) ///
	ytitle("EPL index, version 1") ///
	select(wanted==1)
*~~~~~ Beispiel 2: Paella-Problem
use "uegdp1.dta", clear
separate gdpgrowth, by(region) generate(gdp_) shortlabel
graph twoway scatter gdp_* uer15_19
*~~~~~ unzufriedenstellende Lösung #1: Transparenz
graph twoway scatter gdp_* uer15_19, ///
	mcolor(%25 %25 %25 %25)
*~~~~~ unzufriedenstellende Lösung #2: by-Option
graph twoway scatter gdpgrowth uer15_19, ///
	by(region)
*~~~~~ bessere Lösung: Front-and-back-Plot
fabplot scatter gdpgrowth uer15_19, ///
	by(region)
fabplot scatter gdpgrowth uer15_19, ///
	by(country2) ///
	mcolor(gs12%50) ///
	frontopts( ///
		msymbol(none) ///
		mlabposition(0) ///
		mlabel(country2))
*~~~~~ Anmerkung: Option needvars() nicht dokumentiert (Email Nicolas J. Cox)
fabplot scatter gdpgrowth uer15_19, ///
	by(region) ///
	needvars(country2) ///
	mcolor(gs12%50) ///
	frontopts( ///
		msymbol(none) ///
		mlabposition(0) ///
		mlabel(country2) ///
		mlabsize(tiny))

	