*******************************************************************
***** Christmas Greetings                                     *****
***** inspired by https://www.youtube.com/watch?v=PQYwuheyQgk *****
***** further developed 12/2024 by C. Brzinsky-Fay            *****
*******************************************************************
clear all
set matsize 700
set more off
set obs 50
generate u=0.025*invnorm(uniform())
generate x=_n
generate y=0.1*ln(x)-0.395+u/(0.1*x)
replace y=-0.02 if x<10
replace y=0 if y>0
replace y=0 in 50
generate z=-y
generate star=0 if(x)==50
graph twoway ///
	(pci 3.5 0.05 3.5 0.1, lwidth(1cm) lcolor(navy)) ///
	(pci 3.5 0.05 3.5 0.1, lcolor(gold)) ///
	(pci 6 0.075 1 0.075, lcolor(gold)) ///
	(area x y, fintensity(100) color(forest_green) msymbol(none) xscale(range(-0.4 0.4))) ///
	(area x z, fintensity(100) color(forest_green) msymbol(none)) ///
	(scatter x star, msize(vlarge) msymbol(X) mcolor(gold) mlwidth(thick)) ///
	(scatter x star, msize(huge) msymbol(+) mcolor(gold) mlwidth(thick)) ///
	(pci 9 0 0 0, lwidth(1cm) lcolor(sienna)) ///
	(scatteri 35 0.01, msize(huge) mcolor(maroon)) ///
	(scatteri 11 -0.025, msize(huge) mcolor(maroon)) ///
	(scatteri 25 -0.01, msize(vlarge) mcolor(maroon)) ///
	(scatteri 18 -0.05, msize(huge) mcolor(maroon)) ///
	(scatteri 20 0.025, msize(huge) mcolor(maroon)) ///
	(scatteri 12 0.05, msize(vlarge) mcolor(maroon)), ///
		xtitle("") ytitle("") ///
		xlabel(none) ylabel(none) ///
		xscale(off) yscale(off) ///
		legend(off) ///
		title("!!! Nerdy Christmas !!!") ///
		note("Always similar, but never the same.", size(tiny))

