*! Histogram-Beispiele, created by C. Brzinsky-Fay, 08/2025

*capture program drop hist1de
*capture program drop hist1en
*capture program drop hist2de
*capture program drop hist2en
*capture program drop hist3de
*capture program drop hist3en
*capture program drop hist4de
*capture program drop hist4en

program iahf_hist_ex
	version 19.5
	set more off
	`0'
end

program hist1de
	quietly use "data1.dta", clear
	histogram lsat, ///
		frequency ///
		discrete ///
		title("Lebenszufriedenheit") ///
		subtitle("0 = gar nicht zufrieden, 10 = sehr zufrieden") 
end

program hist1en
	quietly use "data1.dta", clear
	histogram lsat, ///
		frequency ///
		discrete ///
		title("Life Satisfaction") ///
		subtitle("0 = Not satisfied at all, 10 = Very satisfied") 
end

program hist2de
	quietly use "data1.dta", clear
	histogram lsat, ///
		frequency ///
		discrete ///
		title("Lebenszufriedenheit") ///
		subtitle("0 = gar nicht zufrieden, 10 = sehr zufrieden") ///
		note("Quelle: Sozioökonomisches Panel (2009)")
end

program hist2en
	quietly use "data1.dta", clear
	histogram lsat, ///
		frequency ///
		discrete ///
		title("Life Satisfaction") ///
		subtitle("0 = Not satisfied at all, 10 = Very satisfied") ///
		note("Source: German Socio-Economic Panel (2009)")
end

program hist3de
	quietly use "data1.dta", clear
	quietly mvdecode income, mv(0=.)
	quietly replace income=. if income>100000
	histogram income if sex==1, ///
		frequency ///
		color(emerald) ///
		xtitle("Individuelles Erwerbseinkommen") ///
		title("Einkommensverteilung nach Geschlecht") ///
		addplot(histogram income if sex==2, frequency color(gold))
end

program hist3en
	quietly use "data1.dta", clear
	quietly mvdecode income, mv(0=.)
	quietly replace income=. if income>100000
	histogram income if sex==1, ///
		frequency ///
		color(emerald) ///
		xtitle("Individual Labour Income") ///
		title("Income Distribution by Sex") ///
		addplot(histogram income if sex==2, frequency color(gold))
end

program hist4de
	quietly use "data1.dta", clear
	quietly mvdecode income, mv(0=.)
	quietly replace income=. if income>100000
	histogram income if sex==1, ///
		frequency ///
		color(emerald%30) ///
		xtitle("Individuelles Erwerbseinkommen") ///
		title("Einkommensverteilung nach Geschlecht") ///
		addplot(histogram income if sex==2, frequency color(gold%30)) ///
		legend(off)
end

program hist4en
	quietly use "data1.dta", clear
	quietly mvdecode income, mv(0=.)
	quietly replace income=. if income>100000
	histogram income if sex==1, ///
		frequency ///
		color(emerald%30) ///
		xtitle("Individual Labour Income") ///
		title("Income Distribution by Sex") ///
		addplot(histogram income if sex==2, frequency color(gold%30)) ///
		legend(off)
end

program hist5de
	quietly use "data1.dta", clear
	quietly summarize rent, detail
	histogram rent, ///
		frequency ///
		xline(`r(mean)', lcolor(red)) ///
		xline(`r(p50)', lcolor(green)) ///
		xtitle("Monatliche Mietkosten") ///
		color(%30)
end
